IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Eventos_Canje_Clientes_Validar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Eventos_Canje_Clientes_Validar
END
GO

CREATE PROCEDURE dbo.CPJ_Eventos_Canje_Clientes_Validar @pJsonRecibido VARCHAR(MAX)
AS
SET NOCOUNT ON

	IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Eventos_Canje_Clientes_Validar_') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
	BEGIN 
		EXEC CPJ_Eventos_Canje_Clientes_Validar_ @pJsonRecibido
		RETURN
	END	

	/***************************************************************************************************

	Procedimiento:      CPJ_Eventos_Canje_Clientes_Validar
	Fecha de Creacion:  2024-01-24
	Creado por:         Adriana Laverde
	Descripcion:        Stored creado para validar los socios que pueden comprar localidades en el modulo de Canjes
	Llamado por:        events_clients_validate.php (API)
	Tablas afectadas:   []
	Usado en:           
	Parametro(s):       FlagUsarTrans, ModoDebug, Id_Evento_Grupo, Id_Lista_Evento, Doc_Nro
	Forma de uso:       EXEC CPJ_Eventos_Canje_Clientes_Validar '{"FlagUsarTrans":"0","ModoDebug":"0","Id_Evento_Grupo":"0","Id_Lista_Evento":"0","Doc_Nro":"99555555"}'
	Notas adicionales:  Usar CPJ_Eventos_Canje_Clientes_Validar_ para validaciones particulares

	****************************************************************************************************

	SUMARIO DE CAMBIOS
	FECHA(yyyy-mm-dd)    Autor              Comentarios
	------------------- ------------------- ------------------------------------------------------------

              
	***************************************************************************************************/

/*Variables recibidas por parametro a traves del JSON*/
DECLARE	@pFlagUsarTrans			TINYINT,
		@pModoDebug				TINYINT,
		@pId_Evento_Grupo		INT,
		@pId_Lista_Evento		INT,
        @pDoc_Nro				VARCHAR(20)

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)
SET @pId_Evento_Grupo			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Evento_Grupo')),0)
SET @pId_Lista_Evento			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Lista_Evento')),0)
SET @pDoc_Nro					= ISNULL(CONVERT(VARCHAR(20), dbo.CF_JSON_VALUE(@pJsonRecibido,'Doc_Nro')),'')
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored			INT
DECLARE @rtaMsjStored			VARCHAR(4000)
/*FIN Variable de Retorono del Stored*/

/*Variables Locales*/
DECLARE @Fecha						VARCHAR(30)
DECLARE @Existe						INT = 0
DECLARE @Id_Tipo_Cli				SMALLINT
DECLARE @Flag_Entrada_Ya_Adquirida	TINYINT
DECLARE @Id_Cliente					INT
DECLARE @Ult_Cuota_Paga				DATETIME
DECLARE @Min_Ult_Cuota_Paga			DATETIME
DECLARE @Descripcion				VARCHAR(100)
DECLARE @Email						VARCHAR(300)
DECLARE @Razon_Social				VARCHAR(100)
DECLARE @Contador					INT
DECLARE @Fecha_Alta					DATETIME
DECLARE @Antiguedad					INT
DECLARE @Flag_UCP_Validar			SMALLINT
/*FINVariables Locales*/

BEGIN TRY
	IF (@pFlagUsarTrans <> 0)
	BEGIN
		BEGIN TRAN
	END

	IF (@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Eventos_Canje_Clientes_Validar'
		PRINT 'Parametros: '+ @pJsonRecibido  
		PRINT ' ---------------------- '
	END

		-----------------------------------------------------------------------------------------------

		SELECT @Contador = COUNT(*) 
		FROM Clientes C, Clientes_Tipos T
		WHERE C.Id_Tipo_Cli = T.Id_Tipo_Cli
		AND Doc_Nro = CAST(@pDoc_Nro AS BIGINT) 
		AND C.Activo = 1
		AND T.Flag_Tipo IN ('S','P')

		IF (@Contador > 1)
		BEGIN
			SELECT  5001 AS ErrorNumber
				,1 AS ErrorSeverity
				,1 AS ErrorState
				,1 AS ErrorProcedure
				,1 AS ErrorLine
				,'Inconsistencia de datos' AS ErrorMessage
			RETURN 9999
		END
		ELSE
		IF (@Contador = 1)
		BEGIN
			SELECT @Existe = Id_Cliente
			FROM Clientes C, Clientes_Tipos T
			WHERE C.Id_Tipo_Cli = T.Id_Tipo_Cli
			AND Doc_Nro = CAST(@pDoc_Nro AS BIGINT) 
			AND C.Activo = 1
			AND T.Flag_Tipo IN ('S','P')
		END

		-----------------------------------------------------------------------------------------------

	IF (@Existe > 0)
	BEGIN
		
		SET @Id_Cliente = @Existe

		SELECT @Id_Tipo_Cli		= ISNULL(CT.Id_Tipo_Cli, 0),
			   @Ult_Cuota_Paga	= ISNULL(CL.Ult_Cuota_Paga, '19000101'),
			   @Descripcion		= ISNULL(CT.Descrip_Corta, ''),
			   @Email			= ISNULL(CL.Email_Web, ''),
			   @Razon_Social	= ISNULL(CL.Razon_Social,''),
			   @Fecha_Alta		= ISNULL(CL.Fecha_Alta,''),
			   @Antiguedad		= ISNULL((DATEDIFF(DAY, CL.Fecha_Alta, GETDATE())),0)
		FROM Clientes CL, Clientes_Tipos CT 
		WHERE CL.Id_Tipo_Cli = CT.Id_Tipo_Cli
		AND Id_Cliente = @Id_Cliente

		SELECT  @Min_Ult_Cuota_Paga = UCP_Min_Validar,
				@Fecha				= Fecha_Evento,
				@Flag_UCP_Validar	= T.Flag_UCP_Validar
		FROM Prod_Listas_Precios P, Prod_Listas_Precios_Cli_Tipos T
		WHERE P.Id_Lista_Precio = T.Id_Lista_Precio
		AND P.Id_Lista_Precio = @pId_Lista_Evento
		AND T.Id_Tipo_Cli = @Id_Tipo_Cli

		IF (@pModoDebug = 1)
		BEGIN
			PRINT 'Id_Cliente: '+ CONVERT(VARCHAR(20), @Id_Cliente)
			PRINT 'Id_Tipo_Cli: '+ CONVERT(VARCHAR(20), @Id_Tipo_Cli)
			PRINT 'Ult_Cuota_Paga: '+ CONVERT(VARCHAR(12), @Ult_Cuota_Paga)
		END

		-----------------------------------------------------------------------------------------------
		
		IF NOT EXISTS ( SELECT 1
						FROM Prod_Listas_Precios_Cli_Tipos
						WHERE Id_Lista_Precio = @pId_Lista_Evento
						AND Id_Tipo_Cli = @Id_Tipo_Cli )
		BEGIN
			SELECT  5002 AS ErrorNumber
				,1 AS ErrorSeverity
				,1 AS ErrorState
				,1 AS ErrorProcedure
				,1 AS ErrorLine
				,'Categoría de socio no válida' AS ErrorMessage
			RETURN 9999
		END

		-----------------------------------------------------------------------------------------------

		IF ((CONVERT(DATE, @Ult_Cuota_Paga) < CONVERT(DATE,@Min_Ult_Cuota_Paga)) AND @Flag_UCP_Validar = 1)
		BEGIN
			SELECT  5003 AS ErrorNumber
				,1 AS ErrorSeverity
				,1 AS ErrorState
				,1 AS ErrorProcedure
				,1 AS ErrorLine
				,'El socio debe cuotas' AS ErrorMessage
			RETURN 9999
		END

		-----------------------------------------------------------------------------------------------

		SET @Flag_Entrada_Ya_Adquirida = ISNULL((
										 SELECT TOP 1 1
												FROM Cbtes_Items CI 
												LEFT JOIN Cbtes C	ON CI.Id_Trans = C.Id_Trans
												LEFT JOIN Productos P	ON CI.Id_Producto = P.Id_Producto
												LEFT JOIN Cbtes_Tipos CT	ON C.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
												LEFT JOIN Prod_Listas_Precios PL	ON C.Id_Lista = PL.Id_Lista_Precio
												WHERE 
												CI.Id_Cliente = @Id_Cliente
												AND P.Tipo = 'L'
												AND PL.Activo = 1
												AND CI.Fecha_QA <= @Fecha
												AND CI.Fecha_Venc >= @Fecha
												AND PL.Id_Evento_Grupo IN (@pId_Evento_Grupo)
												AND (CT.Compromete_Factura = 1 OR CT.Compromete_Pedido = 1)
												AND C.Id_Estado_Cbte NOT IN (3)
										),0)

		IF (@pModoDebug = 1)
		BEGIN
			PRINT 'Flag_Entrada_Ya_Adquirida: '+ CONVERT(VARCHAR(5), @Flag_Entrada_Ya_Adquirida)
		END
		

		IF (@Flag_Entrada_Ya_Adquirida = 1)
		BEGIN
			SELECT  5004 AS ErrorNumber
				,1 AS ErrorSeverity
				,1 AS ErrorState
				,1 AS ErrorProcedure
				,1 AS ErrorLine
				,'El socio posee una localidad vigente' AS ErrorMessage
			RETURN 9999
		END

		-----------------------------------------------------------------------------------------------

		SELECT  @Id_Cliente AS 'Id_Cliente', 
				@Razon_Social AS 'Razon_Social', 
				@Fecha_Alta AS 'Fecha_Alta', 
				@Email AS 'Email', 
				@Descripcion AS 'Categoria', 
				@Antiguedad AS 'Antiguedad',
				CONVERT(DATE,@Ult_Cuota_Paga) AS 'Ult_Cuota_Paga'

	END
	ELSE
	BEGIN

		SELECT  5010 AS ErrorNumber
				,1 AS ErrorSeverity
				,1 AS ErrorState
				,1 AS ErrorProcedure
				,1 AS ErrorLine
				,'Documento inexistente' AS ErrorMessage
		RETURN 9999

	END
	
	/*====================================================================================================================================================*/

	IF @pFlagUsarTrans <> 0 COMMIT
	
	/*====================================================================================================================================================*/

	IF (@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Eventos_Canje_Clientes_Validar'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 
